/* ============ */
/* specdefs.h	*/
/* ============ */
/* ==================================================================== */
/* 	     MACROS AND PROTOTYPES FOR SPECTRAL.CX AND FRIENDS		*/
/* ==================================================================== */
# if defined(__SPECTRAL_H__)
#	/* Do Nothing */
# else
#	define	__SPECTRAL_H__

# if defined(DEBUG)
#	define	P(S)	S
# else
#	define	P(S)
# endif

/* ---------------------------------------------- */
/* CLR_VECTOR - Clears N extended words at A to 0 */
/* ---------------------------------------------- */
#define CLR_VECTOR(N, A)		\
	memset(A, 0, (N)*NE*sizeof(USHORT))
/* ----------------------------------------------------------- */
/* COMPLETE_UV - Computes New Column of Vmat & New Row of Umat */
/* ----------------------------------------------------------- */
#define	COMPLETE_UV(Umat, Vmat, NewT, M, T, R1, R2)		\
    {								\
	short	i;					        \
	for (i = 1; i < NewT; ++i)			        \
	{						        \
	    USHORT  Q[NE], Tmp1[NE];			        \
	    XMULT(R1, Vmat + XML(i,1,T), Vmat + XML(i,NewT,T));	\
	    XMULT(R2, Vmat + XML(i,2,T), Tmp1);			\
	    XRADD(Vmat + XML(i,NewT,T), Tmp1);			\
	    XDIV(Vmat + XML(i,NewT,T), M, Q);			\
	    XROUND(Q, Q);				        \
	    MOD_UROW(Umat, NewT, i, NewT, T, Q);	 	\
	    XRMULT(Q, M);					\
	    XRSUB(Vmat + XML(i,NewT,T), Q);			\
	}							\
    }
/* ------------------------------------------------------- */
/* DECREASE_Y - Diminishes Y per Step S10 of Spectral Test */
/* ------------------------------------------------------- */
#define	DECREASE_Y(Y, U, K, Zk, N, T)			\
    {							\
	short	i;					\
	for (i = 1; i <= N; ++i)			\
	{						\
	    USHORT  UiZk[NE];				\
	    XMULT(U + XML(K, i, T), Zk, UiZk);		\
	    XRMULT(UiZk, ETWO);				\
	    XRSUB(Y + XVL(i), UiZk);			\
	}						\
    }
/* -------------------------------------------------------------- */
/* DOT - Calculates extended dot product of Row of U and Row of V */
/* -------------------------------------------------------------- */
#define DOT(Nelem, U, RowNumU, V, RowNumV, T, R)	\
    XdotProd(Nelem, U + XML(RowNumU, 1, T), V + XML(RowNumV, 1, T), R)

/* -------------------------------------------------------------------- */
/* FINISH UV - Updates U & V matrices per step S4 of Spectral Test	*/
/* -------------------------------------------------------------------- */
#define FINISH_UV(Umat, Vmat, NewT, M, T, R)		        \
    {							        \
	short	j;					        \
	for (j = 1; j < NewT; ++j)			        \
	{						        \
	    USHORT  Q[NE];				        \
	    XDIV(R, M, Q);				        \
	    XRMULT(Q, Vmat + XML(j,1,T));		        \
	    XROUND(Q, Q);				        \
	    MOD_UROW(Umat, NewT, j, NewT, T, Q)		 	\
	    XMULT(Vmat + XML(j,1,T), R, Vmat + XML(j,NewT,T));	\
	    XRMULT(Q, M);					\
	    XRSUB(Vmat + XML(j,NewT,T), Q);			\
	}							\
    }
/* ---------------------------------------- */
/* INCREASE_Y - Adds Row K of U to Vector Y */
/* ---------------------------------------- */
#define INCREASE_Y(Y, U, K, N, T)			\
    {							\
	short	j;					\
	for (j = 1; j <= N; ++j) 			\
	{						\
	    XRADD(Y + XVL(j), U + XML(K, j, T));	\
	}						\
    }

/* ---------------------------------------------------- */
/* INIT_MAT - Initializes space for Matrix of size T*T	*/
/* ---------------------------------------------------- */
#define	INIT_MAT(A, T)					\
    {							\
	A = (USHORT *) calloc(T*T, NE*sizeof(USHORT));	\
	assert(A != NULL);				\
    }
/* ---------------------------------------------------- */
/* INIT_MAT_2 - Initializes Starting Values in Matrix A	*/
/* ---------------------------------------------------- */
#define	INIT_MAT_2(A, Val, T)                           \
    {                                                   \
	XCOPY(Val, A + XML(1,1,T));                     \
	XCOPY(Val, A + XML(2,2,T));                     \
    }
/* -------------------------------------------------- */
/* INIT_R_MAT - Initializes Matrix R When HowMany = 2 */
/* -------------------------------------------------- */
#define	INIT_R_MAT(R11, R12, R21, R22)                  \
    {                                                   \
	XCOPY(EONE, R11);                               \
	XCOPY(EZERO, R12);                              \
	XCOPY(EZERO, R21);                              \
	XCOPY(EONE, R22);                               \
	PRT_RMAT(R11, R12, R21, R22);			\
    }
/* ---------------------------------------------------- */
/* INIT_VEC - Initializes space for a Vector of size T	*/
/* ---------------------------------------------------- */
#define INIT_VEC(V, T)					\
    {							\
	V = (USHORT *) calloc(T, NE*sizeof(USHORT));	\
	assert(V != NULL);				\
    }
/* -------------------------------------------------------------------- */
/* INIT_UMAT - Initializes 2x2 U matrix before step S4 in Spectral Test */
/* -------------------------------------------------------------------- */
#define INIT_UMAT(Umat, T)				\
    {							\
	XCOPY(XH, Umat + XML(1,1,T));			\
	XNEG(Umat + XML(1,1,T));			\
	XCOPY(XP, Umat + XML(1,2,T));			\
	XCOPY(XHP, Umat + XML(2,1,T));			\
	XNEG(Umat + XML(2,1,T));			\
	XCOPY(XPP, Umat + XML(2,2,T));			\
    }
/* -------------------------------------------------------------------- */
/* INIT_VMAT - Initializes 2x2 V matrix before step S4 in Spectral Test */
/* -------------------------------------------------------------------- */
#define INIT_VMAT(Vmat, T)				\
    {							\
	USHORT Sign[NE];                		\
	XCOPY(EONE, Sign);				\
	if (XGT(XPP, EZERO)) XNEG(Sign);		\
	XMULT(Sign, XPP, Vmat + XML(1,1,T));		\
	XMULT(Sign, XHP, Vmat + XML(1,2,T));		\
	XNEG(Sign);					\
	XMULT(Sign, XP, Vmat + XML(2,1,T));		\
	XMULT(Sign, XH, Vmat + XML(2,2,T));		\
    }
/* -------------------------------------------------------------------- */
/* INIT_UNEW - Initializes first and last elements of new row in Umat	*/
/* -------------------------------------------------------------------- */
#define INIT_UNEW(Umat, NewT, R, T)			\
    {							\
	XCOPY(R, Umat + XML(NewT,1,T));			\
	XNEG(Umat + XML(NewT,1,T));			\
	XCOPY(EONE, Umat + XML(NewT,NewT,T));		\
    }
/* ------------------------------------------------------- */
/* INIT_VNEW - Initializes last element in new row in Vmat */
/* ------------------------------------------------------- */
#define INIT_VNEW(Vmat, NewT, M, T)			\
    {							\
	XCOPY(M, Vmat + XML(NewT, NewT, T));		\
    }
#define	LDBLPRT(X, N, S)				\
    {							\
	short   i, j;					\
	printf("%s\n", S);				\
	for (i = 0; i < N; ++i)				\
	{						\
	    for (j = 0; j < sizeof(long double); ++j)   \
	    {                                           \
	        printf(" %.4X", ((char *)(X+i))[j]);    \
	    }                                           \
	    printf("\n");				\
        }			                       	\
    }
/* ------------------------------------------------------- */
/* MATPRT - Prints I x I Matrix A Embedded in T x T matrix */
/* ------------------------------------------------------- */
#
# if !defined(DEBUG)
#	define MATPRT(A, I, T, S)
# else
#define MATPRT(A, I, T, S)				\
    {							\
	XmatPrt(A, I, T, stdout, S);			\
    }
# endif
/* -------------------------------------------------------------------- */
/* MOD_UROW - Modifies row J of U matrix per S4 & S5 of Spectral Test	*/
/* -------------------------------------------------------------------- */
#define MOD_UROW(Umat, J, I, N, T, Q)			\
    {							\
	short	k;					\
	for (k = 1; k <= N; ++k)			\
	{						\
	    USHORT  QUi[NE];				\
	    XMULT(Umat + XML(I, k, T), Q, QUi);		\
	    XRADD(Umat + XML(J, k, T), QUi);		\
	}						\
    }
/* -------------------------------------------------------------------- */
/* MOD_VROW - Modifies row I of V matrix per S5 of Spectral Test	*/
/* -------------------------------------------------------------------- */
#define MOD_VROW(Vmat, I, J, N, T, Q)			\
    {							\
	short	k;					\
	for (k = 1; k <= N; ++k)			\
	{						\
	    USHORT  QVj[NE];				\
	    XMULT(Vmat + XML(J, k, T), Q, QVj);		\
	    XRSUB(Vmat + XML(I, k, T), QVj);		\
	}						\
    }
/* ----------------------------------------------------------- */
/* PRT_RMAT - Prints 2 x 2 R Matrix in Two-Parameter Algorithm */
/* ----------------------------------------------------------- */
# if !defined(DEBUG)
#define	PRT_RMAT(R11, R12, R21, R22)
# else
#define	PRT_RMAT(R11, R12, R21, R22)			\
    {							\
	XPRINTF("R11: ", R11, 20);			\
	XPRINTF("R12: ", R12, 20);			\
	XPRINTF("R21: ", R21, 20);			\
	XPRINTF("R22: ", R22, 20);			\
    }
# endif
/* ----------------------------------------------------------- */
/* SET_NEW_RMAT - Calculates new elements of Virtual Mmatrix R */
/* ----------------------------------------------------------- */
#define	SET_NEXT_RMAT(R11, R12, R21, R22, XA, XB, M)    \
    {                                                   \
	USHORT	Tmp1[NE];                               \
	XMULT(R11, XB, Tmp1);                           \
	XCOPY(R12, R11);                                \
	XRMULT(R12, XA);                                \
	XRADD(R12, Tmp1);                               \
	XMULT(R21, XB, Tmp1);                           \
	XCOPY(R22, R21);                                \
	XRMULT(R22, XA);                                \
	XRADD(R22, Tmp1);                               \
	XMOD(R12, M, R12);                              \
	XMOD(R22, M, R22);                              \
	PRT_RMAT(R11, R12, R21, R22);			\
    }
/* -------------------------------------------------------------------- */
/* SET_NEXT_UROW - Sets 1st, 2nd and last elements of new row in Umat	*/
/* -------------------------------------------------------------------- */
#define SET_NEXT_UROW(Umat, NewT, R1, R2, T)		\
    {							\
	XCOPY(R1, Umat + XML(NewT,1,T));		\
	XNEG(Umat + XML(NewT,1,T));			\
	XCOPY(R2, Umat + XML(NewT,2,T));		\
	XNEG(Umat + XML(NewT,2,T));			\
	XCOPY(EONE, Umat + XML(NewT,NewT,T));		\
    }
/* --------------------------------------------------- */
/* TRANSFORM - Transforms U and V Matrices per Step S5 */
/* --------------------------------------------------- */
#define TRANSFORM(V, I, U, J, Vij, Vjj, N, T)		\
    {							\
	USHORT	Q[NE];					\
	XDIV(Vij, Vjj, Q);				\
	XROUND(Q, Q);					\
	MOD_VROW(V, I, J, N, T, Q);			\
	MOD_UROW(U, J, I, N, T, Q);			\
    }
/* ----------------------------------------------- */
/* VECPRT - Prints I-Element Vector A with Label S */
/* ----------------------------------------------- */
# if !defined(DEBUG)
#	define VECPRT(A, I, S)
# else
#define VECPRT(A, I, S) 				\
    {							\
	short	m;					\
	printf("%s\n", S);				\
	for (m = 1; m <= I; ++m) 			\
	{						\
	    char    Label[16];				\
	    sprintf(Label, "   (%2d) ", m);		\
	    XPRINTF(Label, A + XVL(m), NDEC);		\
	}						\
    }
# endif
#include <float.h>
/* Floating point debug print sequence */
#define FIRE	\
    {\
	unsigned int	Status87 = _status87();\
	if (Status87 != 0)\
	{\
	 printf("Error File %s, Line %d, Status87 = %.4x\n",\
		 __FILE__, __LINE__, Status87);\
	 exit(1);\
	}\
    }
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	void	CalcMerit	F((void *, short, void *, void *));
extern	void	EuclStep	F((void *, void *, void *, void *,
				    void *, void *, void *));
extern	void	fPutXFrac	F((FILE *, void *, short, short));
extern	void	fPutXInt	F((FILE *, void *, short));
extern	short	GetControlData	F((void *, void *, short *, short *));
extern	void	GetGCD		F((void *, void *, void *));
extern	void	GetShort	F((char *, short *));
extern	void	GetStr		F((char *, char *));
extern	void	PrintSprectalData F((void *, void *, short));
extern	void	PutXFlt		F((void *, short, short));
extern	void	PutXFrac	F((void *, short, short));
extern	void	PutXInt		F((void *, short));
extern	void	XdotProd	F((short, void *, void *, void *));
extern	void	XmatPrt		F((void *, short, short, FILE *, char *));
extern	void	Xmod		F((void *, void *, void *));

# undef F
/* INDENT ON */

# endif			/* <<<__SPECTRAL_H__>>> */
